"""
TTLs for RTC Juggler checks.

"""

from infra.reconf_juggler.opts.ttls import TtlHandler

_SECOND = 1
_MINUTE = 60 * _SECOND
_HOUR = 60 * _MINUTE


class TenMinutes(TtlHandler):
    @staticmethod
    def get_defaults():
        return {'ttl': 10 * _MINUTE}


class EighteenMinutes(TtlHandler):
    @staticmethod
    def get_defaults():
        return {'ttl': 1100 * _SECOND}


class HalfAnHour(TtlHandler):
    @staticmethod
    def get_defaults():
        return {'ttl': 30 * _MINUTE}


class FortyFiveMinutes(TtlHandler):
    @staticmethod
    def get_defaults():
        return {'ttl': 45 * _MINUTE}


class OneHour(TtlHandler):
    @staticmethod
    def get_defaults():
        return {'ttl': 1 * _HOUR}


class OneHourAndAHalf(TtlHandler):
    @staticmethod
    def get_defaults():
        return {'ttl': 150 * _MINUTE}


class ThreeHours(TtlHandler):
    @staticmethod
    def get_defaults():
        return {'ttl': 3 * _HOUR}


class FourHours(TtlHandler):
    @staticmethod
    def get_defaults():
        return {'ttl': 4 * _HOUR}
