from infra.rtc.jyggalag.clients.qloud_service import QloudService


class QloudHost:

    def __init__(self, installation: str = None, data=None):
        if isinstance(data, str):
            self.name = data
            self.segment = None
            self.state = None
            self.installation = None
            self.memory = 0.0
            self.cpu = 0.0
            self.comment = None
            self.dc = None
            self.ssd = 0
            self.hdd = 0
            self.services = dict()
            self.empty_data = True
            self.name = data
            return

        self.segment = '{installation}.{segment}'.format(installation=installation, segment=data['segment'])
        self.state = str(data['state']).upper()
        self.installation = installation
        self.name = str(data['fqdn'])
        self.memory = float(data['memoryBytes']) / 1024.0 / 1024.0 / 1024.0
        self.cpu = int(data['cpu'])
        self.comment = None
        if 'comment' in data:
            self.comment = str(data['comment'])
        if 'dataCenter' in data:
            self.dc = str(data['dataCenter']).upper()
        self.ssd = 0
        self.hdd = 0
        self.services = dict()
        self.is_empty_data = True

        for disk in data['disks']:
            if 'allocationMountPoint' in disk and len(disk['allocationMountPoint']) > 0:
                if disk['type'].upper() == 'SSD':
                    self.ssd += float(disk['size'])/1024.0/1024.0/1024.0
                elif disk['type'].upper() == 'HDD':
                    self.hdd += float(disk['size'])/1024.0/1024.0/1024.0
                else:
                    raise Exception("Weird disk on host {host}".format(host=self.name))
        for slot in data['slots']:
            self.services[slot['issSlot']] = QloudService('{installation}.{component}'.format(
                installation=self.installation,
                component=slot['componentId']
            ))

        if (
                'nocDC' in data and
                'line' in data and
                data['nocDC'] is not None and
                data['line'] is not None and
                self.cpu is not None and self.cpu != 0 and
                self.memory is not None and self.memory != 0):
            self.is_empty_data = False

    def services_cpu(self):
        result = 0
        for s in self.services.keys():
            result += self.services[s].cpu
        return result

    def services_mem(self):
        result = 0
        for s in self.services.keys():
            result += self.services[s].memory
        return result

    def services_disk(self):
        result = 0
        for s in self.services.keys():
            result += self.services[s].disk
        return result

    def get_full_segment(self):
        return '{seg}.{dc}'.format(
            seg=self.segment,
            dc=self.dc
        )

    def __str__(self):

        pass

    def str_columns(self, columns: list):
        result = list()
        for column in columns:
            column = column.lower()
            if column == 'segment' or column == 'seg' or column == 'sg':
                result.append(self.segment)
            elif column == 'dc':
                result.append(self.dc)
            elif column == 'cpu' or column == 'c':
                result.append(self.cpu)
            elif column == 'mem' or column == 'memory' or column == 'm':
                result.append(self.memory)
            elif column == 'name' or column == 'n' or column == 'fqdn':
                result.append(self.name)
            elif column == 'state' or column == 's':
                result.append(self.state)
            elif column == 'comment':
                result.append(self.comment)
            elif column == 'hdd':
                result.append(self.hdd)
            elif column == 'ssd':
                result.append(self.ssd)
            elif column == 'slots' or column == 'services':
                if self.services is None:
                    result.append(None)
                else:
                    result.append(str(len(self.services)))
            else:
                result.append('NULL')
        return result
