class QloudService:

    def __init__(self, name: str):
        self.installation = name[:name.index('.')]
        self.service = name[name.index('.')+1:]
        self.name = name
        self.segment = None
        self.units = dict()
        self.filled = False
        self.cpu = 0
        self.memory = 0
        self.disk = 0
        self.filled = False

    def get_full_env_name(self):
        return '{installation}.{service}'.format(
            installation=self.installation,
            service='.'.join(self.service.split('.')[:3])
        )

    def get_full_name(self):
        return '{installation}.{service}'.format(installation=self.installation, service=self.service)
