from infra.rtc.jyggalag.jyggalag_config import JyggalagConfig
import requests
import json
import os


class QloudTVM:

    def __init__(self, config: JyggalagConfig):
        self.tvm_daemon_url = config.tvm.get('url_template', 'http://localhost:1/tvm/tickets?dsts={destination}')
        self.tvm_token = os.environ.get('QLOUD_TVM_TOKEN', None)

    def get_ticket(self, destination):
        url = self.tvm_daemon_url.format(destination=destination)
        req = requests.get(
            url=url,
            headers={'Authorization': self.tvm_token}
        )
        text = req.text
        req.raise_for_status()
        return json.loads(text)[destination]['ticket']
