class ResolverHost:

    def __init__(self, data: dict):
        if 'Hosts' not in data and len(data['Hosts']) != 1:
            raise Exception('Invalid Data')

        host_data = data['Hosts'][0]
        if 'InventoryNumber' in host_data:
            self.inv = int(host_data['InventoryNumber'])
        else:
            self.inv = None

        if 'HostName' in host_data:
            self.name = str(host_data['HostName'])
        else:
            self.name = None

        if 'AbcServiceId' in host_data:
            self.abc_id = str(host_data['AbcServiceId'])
        else:
            self.abc_id = None

        if 'DatacenterName' in host_data:
            self.dc = str(host_data['DatacenterName'])
        else:
            self.dc = None

        if 'QueueName' in host_data:
            self.queue = str(host_data['QueueName'])
        else:
            self.queue = None

        if 'SwitchName' in host_data:
            self.switch = str(host_data['SwitchName'])
        else:
            self.switch = None
        self.instances = list()
