import urllib3
import logging
import json
import sys
import os


class JyggalagConfig:
    def __init__(self, conf_path: str = None):
        urllib3.disable_warnings()
        self.conf_data = dict()
        if conf_path is None:
            conf_path = os.path.expanduser('~/.jyggalag/config.json')
        if conf_path is not None and os.path.isfile(conf_path):
            with open(conf_path) as json_data:
                self.conf_data = json.load(json_data)
                json_data.close()
        else:
            raise Exception("Can't run without config")

        self.db = self.conf_data.get('db', None)
        self.qloud = self.conf_data.get('qloud', None)
        self.walle = self.conf_data.get('walle', None)
        self.resolver = self.conf_data.get('instance_resolver', None)
        self.redeploy = self.conf_data.get('redeploy', None)
        self.unistat = self.conf_data.get('unistat', None)
        self.tvm = self.conf_data.get('tvm', None)
        self.application = self.conf_data.get('application', None)
        self.readonly = False
        self.logger = logging.getLogger(__name__)
        self.logger.setLevel(logging.DEBUG)
        logger_stream = logging.StreamHandler(sys.stdout)
        logger_stream.setLevel(logging.DEBUG)
        formatter = logging.Formatter('%(levelname)-8s [%(asctime)-15s] %(message)s')
        logger_stream.setFormatter(formatter)
        self.logger.addHandler(logger_stream)
