from infra.rtc.jyggalag.clients.qloud_host import QloudHost
from infra.rtc.jyggalag.clients.walle_host import WalleHost


class JyggalagHost:

    def __init__(self, db_row=None):
        if db_row is None:
            db_row = (None, None, None, None, None, None, None, None)
        if db_row[0] is not None:
            self.inv = int(db_row[0])
        else:
            self.inv = None

        if db_row[1] is not None:
            self.name = str(db_row[1])
        else:
            self.name = None

        if db_row[2] is not None:
            self.state = str(db_row[2])
        else:
            self.state = None

        if db_row[3] is not None:
            self.update_time = int(db_row[3])
        else:
            self.update_time = 0

        if db_row[4] is not None:
            self.segment = str(db_row[4])
        else:
            self.segment = None

        if db_row[5] is not None:
            self.walle_project = str(db_row[5])
        else:
            self.walle_project = None

        if db_row[6] is not None:
            self.ticket = str(db_row[6])
        else:
            self.ticket = None

        if db_row[7] is not None:
            self.ok_time = int(db_row[7])
        else:
            self.ok_time = None

        self.qloud: QloudHost = None
        self.walle: WalleHost = None

    def is_ok(self):
        if self.update_time is None or self.ok_time is None:
            return False
        return self.ok_time > self.update_time

    def str_columns(self, columns: list):
        result = list()
        for column in columns:
            column = column.lower()
            if self.inv is not None and column == 'inv':
                result.append(str(self.inv))
            elif self.name is not None and column == 'name':
                result.append(str(self.name))
            elif self.walle_project is not None and column == 'jproject':
                result.append(str(self.walle_project))
            elif self.segment is not None and column == 'jsegment':
                result.append(str(self.segment))
            elif self.state is not None and column == 'jstate':
                result.append(str(self.state))
            elif self.qloud is not None and column == 'qsegment':
                result.append(str(self.qloud.segment))
            elif self.qloud is not None and column == 'qname':
                result.append(str(self.qloud.name))
            elif self.qloud is not None and column == 'qdc':
                result.append(str(self.qloud.dc))
            elif self.qloud is not None and column == 'qstate':
                result.append(str(self.qloud.state))
            elif self.qloud is not None and column == 'qslots':
                result.append(str(len(self.qloud.services)))
            elif self.walle is not None and column == 'wproject':
                result.append(str(self.walle.project))
            elif self.walle is not None and column == 'wstate':
                result.append(str(self.walle.state))
            elif self.walle is not None and column == 'wstatus':
                result.append(str(self.walle.status))
            elif column == 'jok':
                result.append(str(self.is_ok()))
            else:
                result.append('NULL')
        return result

    def __str__(self):
        return '[{}]{}'.format(self.inv, self.name)
