from datetime import datetime


class JyggalagLog:

    def __init__(self, data_row):
        if data_row[0] is None:
            self.unix_time = None
        else:
            self.unix_time = int(data_row[0])

        if data_row[1] is None:
            self.inv = None
        else:
            self.inv = int(data_row[1])

        if data_row[2] is None:
            self.name = None
        else:
            self.name = str(data_row[2])

        if data_row[3] is None:
            self.node = None
        else:
            self.node = str(data_row[3])

        if data_row[4] is None:
            self.state_from = None
        else:
            self.state_from = str(data_row[4])

        if data_row[5] is None:
            self.state_to = None
        else:
            self.state_to = str(data_row[5])

    def str_columns(self, columns):
        result = list()
        for column in columns:
            column = column.lower()
            if column == 'inv':
                result.append(str(self.inv))
            elif column == 'name':
                result.append(str(self.name))
            elif column == 'node':
                result.append(str(self.node))
            elif column == 'time':
                result.append(datetime.fromtimestamp(self.unix_time).strftime('%Y-%m-%d %H:%M:%S'))
            elif column == 'state_from':
                result.append(str(self.state_from))
            elif column == 'state_to':
                result.append(str(self.state_to))
            else:
                result.append("NULL")
        return result
