from infra.rtc.jyggalag.jyggalag_config import JyggalagConfig
from infra.rtc.jyggalag.jyggalag_mind import JyggalagMind
from flask import Flask, Response
from jinja2 import Environment, PackageLoader
from logging import Logger
from time import time
import math
import json

env = Environment(
    loader=PackageLoader("infra.rtc.jyggalag", "templates"),
)

releasing_services_template = env.get_template('releasing_services')

app = Flask(__name__)
jyggalag: JyggalagMind
logger: Logger


def start(cfg: JyggalagConfig, mind: JyggalagMind):
    global logger
    global jyggalag
    logger = cfg.logger
    jyggalag = mind
    app.run(
        host=cfg.application.get('host', '::'),
        port=int(cfg.application.get('port', 5000))
    )


@app.route('/unistat', methods=['GET', 'HEAD'])
def get_unistat():
    try:
        metrics = jyggalag.db.get_state_metrics()
        result = list()
        for state in metrics.keys():
            line = list()
            line.append('{state}_{suffix}'.format(state=state, suffix='axxx'))
            line.append(int(metrics[state]))
            result.append(line)

        metrics = jyggalag.machine.environments_metrics
        for state in metrics.keys():
            line = list()
            line.append('environments_{state}_{suffix}'.format(state=state, suffix='axxx'))
            line.append(int(metrics[state]))
            result.append(line)

        if jyggalag.lock_acquired:
            result.append(['lock_acquired_axxx', 1])
        else:
            result.append(['lock_acquired_axxx', 0])
        if jyggalag.wait_lock:
            result.append(['wait_lock_axxx', 1])
        else:
            result.append(['wait_lock_axxx', 0])
        result.append(['global_errors_axxx', jyggalag.last_global_errors])
        result.append(['host_errors_axxx', jyggalag.last_hosts_errors])
        result.append(['exec_time_axxx', jyggalag.last_exec_time])
        timestamp = time()
        result.append(['sine_axxx', math.sin(timestamp / 600.0) + 1])
        result.append(['cosine_axxx', math.cos(timestamp / 600.0) + 1])
        return Response(json.dumps(result))
    except Exception as error:
        logger.exception('Exception during reuest')
        return Response(str(error), status=500)


@app.route('/releasing_services', methods=['GET', 'HEAD'])
def get_reselasing_services():
    return Response(
        releasing_services_template.render(
            title="Releasing Servces",
            service_map=jyggalag.releasing_services
        )
    )


@app.route('/releasing_timeout_services', methods=['GET', 'HEAD'])
def get_timeout_services():
    return Response(
        releasing_services_template.render(
            title="Releasing Timeout Servces",
            service_map=jyggalag.timeout_releasing_services
        )
    )
