package pkg

import (
	"io/ioutil"

	"gopkg.in/yaml.v2"
)

type LoadgenConfig struct {
	Endpoints          []string `yaml:"endpoints"`
	PayloadSizes       []int    `yaml:"payload_sizes"`
	MaxClients         int      `yaml:"max_clients"`
	ConnectionLifetime int      `yaml:"connection_lifetime"`
}

func GetConfig(path string) (*LoadgenConfig, error) {
	content, err := ioutil.ReadFile(path)
	if err != nil {
		return nil, err
	}
	var result LoadgenConfig
	err = yaml.Unmarshal(content, &result)
	if err != nil {
		return nil, err
	} else {
		return &result, nil
	}
}
