package pkg

import (
	"time"

	"golang.org/x/net/context"
	"google.golang.org/grpc"

	pb "a.yandex-team.ru/infra/rtc/loadgen/api"
)

type LoadgenImpl struct {
	latencyHist *LatencyHistogram
}

func NewLoadgenImpl(config *LoadgenConfig) (server *LoadgenImpl) {
	server = &LoadgenImpl{
		latencyHist: NewLatencyHistogram("server", config),
	}
	return
}

func (s *LoadgenImpl) Register(server *grpc.Server) {
	pb.RegisterLoadgenServer(server, s)
}

func (s *LoadgenImpl) Ping(ctx context.Context, in *pb.PingRequest) (*pb.PingReply, error) {
	return &pb.PingReply{}, nil
}

func AbsoluteDelta(a int64, b int64) int64 {
	if a > b {
		return a - b
	} else {
		return b - a
	}
}

func (s *LoadgenImpl) Payload(ctx context.Context, in *pb.PayloadRequest) (*pb.PayloadReply, error) {
	now := time.Now().UnixNano()
	timestampDelta := AbsoluteDelta(now, int64(in.Timestamp))
	s.latencyHist.Update(len(in.Payload), float64(timestampDelta)/1000.0)
	return &pb.PayloadReply{Payload: in.Payload, Timestamp: uint64(now)}, nil
}
