package pkg

import (
	"net/http"

	"github.com/grpc-ecosystem/grpc-gateway/runtime"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/unistat"
)

func NewUnistatHandle(unistatPath string, mux *runtime.ServeMux) {
	mux.Handle(
		"GET",
		runtime.MustPattern(runtime.NewPattern(1, []int{2, 0}, []string{unistatPath}, "")),
		func(w http.ResponseWriter, r *http.Request, pathParams map[string]string) {
			b, err := unistat.MarshalJSON()
			if err != nil {
				w.WriteHeader(http.StatusInternalServerError)
				Logger.Error("Unable to render stat handle", log.Error(err))
				return
			}

			w.Header().Set("Content-Type", "application/json")
			if _, err := w.Write(b); err != nil {
				Logger.Error("unable to write", log.Error(err))
				return
			}
		},
	)
}
