from infra.ya_salt.lib import walle


class LocationInfo(object):
    @classmethod
    def from_walle_info(cls, info):
        return cls(
            country=info['raw_country'],
            city=info['raw_city'],
            building=info['raw_datacenter'],
            line=info['raw_queue'],
            rack=info['raw_rack']
        )

    def __init__(self, country=None, city=None, building=None, line=None, rack=None):
        self.country = country
        self.city = city
        self.building = building
        self.line = line
        self.rack = rack


def get_location_info(load_fun=walle.load_from_fs):
    info, err = load_fun()
    if err is not None and err != walle.NEED_RE_SYNC_ERR:
        return None, err
    return LocationInfo.from_walle_info(info), None
