import json
import os
import subprocess


class LSHWCPUInfo(object):
    def __init__(self, model_name, vendor, threads, cores):
        self.model_name = model_name
        self.vendor = vendor
        self.threads = threads
        self.cores = cores

    def __eq__(self, other):
        return self.model_name == other.model_name \
            and self.vendor == other.vendor \
            and self.threads == other.threads \
            and self.cores == other.cores


def lshw_output():
    if not os.path.exists('/usr/bin/lshw'):
        return None, 'lshw is not installed at /usr/bin/lshw'
    try:
        out = subprocess.check_output(
            ['/usr/bin/lshw', '-json', '-notime', '-quiet', '-c', 'cpu']
        )
        return json.loads(out), None
    except Exception as e:
        return None, 'failed to query cpu info via lshw invocation: {}'.format(e)


def get_cpu_info(lshw=lshw_output):
    j, err = lshw()
    if err is not None:
        return None, err
    rv = []
    for i in j:
        rv.append(LSHWCPUInfo(
            i.get('product', 'unknown model'),
            i.get('vendor', 'unknown vendor'),
            int(i.get('configuration', {}).get('cores', 0)),
            int(i.get('configuration', {}).get('threads', 0)),
        ))
    return rv, None
