import io

from infra.ya_salt.lib import fileutil


class MemInfo(object):
    def __init__(self):
        self.total_bytes = 0


def mem_info_from_buf(buf):
    f = io.BytesIO(buf)
    mi = MemInfo()
    for l in f:
        fields = l.split(':')
        if len(fields) != 2:
            continue
        k = fields[0].strip()
        v = fields[1].strip()
        v = v.replace(' kB', '')
        try:
            t = int(v, 10)
        except Exception as e:
            return None, str(e)
        if k == 'MemTotal':
            mi.total_bytes = t * 1024
            break
    return mi, None


def mem_info(path='/proc/meminfo'):
    buf, err = fileutil.read_file(path)
    if err is not None:
        return None, err
    return mem_info_from_buf(buf)
