import os


OS_NAME_FIELD = 'DISTRIB_DESCRIPTION'
OS_CODENAME_FIELD = 'DISTRIB_CODENAME'
OS_TYPE_LINUX = 'Linux'
OS_VERSION_UNKNOWN = 'Unknown OS version'
OS_RELEASE_FILE = '/etc/lsb-release'
KERNEL_VERSION_FIELD = 2


class GetOSVersionError(Exception):
    pass


class OSInfo(object):
    def __init__(self, type=None, version=None, kernel=None, codename=None):
        self.type = type
        self.version = version
        self.kernel = kernel
        self.codename = codename


def get_os_version(open_func=open):
    version = None
    codename = None
    with open_func(OS_RELEASE_FILE, 'r') as f:
        for line in f:
            line = line.split('=', 2)
            if len(line) == 2:
                k, v = line[0], line[1]
            else:
                continue
            key_stripped = k.strip()
            if key_stripped == OS_NAME_FIELD:
                version = v.strip().strip('\'"')
            elif key_stripped == OS_CODENAME_FIELD:
                codename = v.strip().strip().strip('\'"')
    if not version:
        raise GetOSVersionError(
            'cannot determine OS version, '
            '{} seems does not have {} field'.format(OS_RELEASE_FILE, OS_NAME_FIELD))
    if not codename:
        raise GetOSVersionError(
            'cannot determine OS codename, '
            '{} seems does not have {} field'.format(OS_RELEASE_FILE, OS_CODENAME_FIELD))
    return version, codename


def get_kernel_version():
    return os.uname()[KERNEL_VERSION_FIELD]


def get_os_type():
    return OS_TYPE_LINUX


def get_os_info(open_func=open):
    """
    :return: OSInfo, error
    """
    os_version, os_codename = get_os_version(open_func=open_func)
    return OSInfo(
        get_os_type(),
        os_version,
        get_kernel_version(),
        os_codename
    )
