import json
import os

from infra.ya_salt.lib import pbutil
from infra.ya_salt.proto import ya_salt_pb2

OVERRIDES_FILE_PATH = '/var/lib/nodeinfo/override.json'


def load_overrides_dict(path=OVERRIDES_FILE_PATH, open_func=open, isfile=os.path.isfile):
    if isfile(path):
        try:
            with open_func(path, 'r') as f:
                return json.load(f), None
        except Exception as e:
            return None, 'failed to load overrides from {}: {}'.format(path, e)
    return None, None


def overrides_from_dict(d):
    ni = ya_salt_pb2.NodeInfo()
    err = pbutil.pb_from_dict(ni, d)
    if err is not None:
        return None, 'failed to parse overrides from dict: {}'.format(err)
    return ni, None


def apply_overrides(ni, open_func=open, isfile=os.path.isfile):
    d, err = load_overrides_dict(open_func=open_func, isfile=isfile)
    if err is not None:
        return 'failed to merge overrides: {}'.format(err)
    # no overrides, no error
    if d is None:
        return None
    overrides, err = overrides_from_dict(d)
    if err is not None:
        return 'failed to merge overrides: {}'.format(err)
    ni.MergeFrom(overrides)
    return None
