import os
import logging
import time

log = logging.getLogger(__name__)

STATE_FILE = '/run/rtc_nodeinfo.state'
FAIL_DELAY_SECONDS = 45 * 60    # 45 minutes, see HOSTMAN-1114 for details


def touch(path=STATE_FILE, utime=os.utime, open_file=open):
    try:
        f = open_file(path, 'w')
        f.close()
        utime(path, None)
    except Exception as e:
        return 'failed to touch {}: {}'.format(path, e)
    return None


def state_error(run_err, path=STATE_FILE, stat=os.stat, now=time.time):
    if run_err is None:
        return None
    else:
        try:
            t = int(now())
            s = stat(path)
            delta = t - s.st_mtime
            if delta > FAIL_DELAY_SECONDS:
                return 'failed to run nodeinfo: {} and state file {} was updated {} seconds ago'.format(run_err, path, delta)
            else:
                return None
        except Exception as e:
            return 'failed to run nodeinfo: {} and failed to check state file {} mtime: {}'.format(run_err, path, e)


def retcode_from_run_error(run_err, s_err=state_error, update_state=touch):
    err = s_err(run_err)
    if err is None:
        ret = 0
        if run_err is None:
            err = update_state()
            if err is not None:
                log.error('Failed to update state file timestamp: {}'.format(err))
                ret = 1
    else:
        log.error('Run failed: {}'.format(err))
        ret = 1
    return ret
