YP_WALLE_TAGS_TO_MASTERS = {
    'rtc.ypmaster-sas_test': 'sas-test.yp.yandex.net',
    'rtc.ypmaster-man_pre': 'man-pre.yp.yandex.net',
    'rtc.ypmaster-sas': 'sas.yp.yandex.net',
    'rtc.ypmaster-vla': 'vla.yp.yandex.net',
    'rtc.ypmaster-man': 'man.yp.yandex.net',
    'rtc.ypmaster-myt': 'myt.yp.yandex.net',
    'rtc.ypmaster-iva': 'iva.yp.yandex.net',
    'rtc.ypmaster-xdc': 'xdc.yp.yandex.net',
}
YP_DATACENTERS = {'sas', 'vla', 'man', 'iva', 'myt'}


def _infer_yp_from_tags(tags):
    matches = set(tags) & set(YP_WALLE_TAGS_TO_MASTERS)
    # we can determine master only if we have matched exactly one tag
    if len(matches) == 1:
        return YP_WALLE_TAGS_TO_MASTERS[matches.pop()]
    return None


def _infer_yp_from_dc(dc):
    if dc in YP_DATACENTERS:
        return '{}.yp.yandex.net'.format(dc)
    return None


def infer_yp_for_host(walle_tags, dc):
    return _infer_yp_from_tags(walle_tags) or _infer_yp_from_dc(dc)
