package pbutil

import (
	"fmt"
	"io/ioutil"
	"os"

	"a.yandex-team.ru/infra/rtc/nodeinfo/soxaudit/internal/fileutil"
	ya_salt_pb2 "a.yandex-team.ru/infra/ya_salt/proto"
	"github.com/golang/protobuf/proto"
)

func Load(path string) (*ya_salt_pb2.SOXSecurityInfo, error) {
	f, err := os.Open(path)
	if err != nil {
		return nil, fmt.Errorf("failed to open %s: %w", path, err)
	}
	defer f.Close()
	stat, err := f.Stat()
	if err != nil {
		return nil, fmt.Errorf("failed fstat(%d): %w", f.Fd(), err)
	}
	if stat.IsDir() {
		return nil, fmt.Errorf("failed to read pb: %s is dir", path)
	}
	content, err := ioutil.ReadAll(f)
	if err != nil {
		return nil, fmt.Errorf("failed to read slots: %w", err)
	}
	soxInfo := &ya_salt_pb2.SOXSecurityInfo{}
	err = proto.Unmarshal(content, soxInfo)
	if err != nil {
		return nil, fmt.Errorf("failed to unmarshal %s: %w", path, err)
	}
	return soxInfo, nil
}

func Save(path string, soxInfo *ya_salt_pb2.SOXSecurityInfo) error {
	bytes, err := proto.Marshal(soxInfo)
	if err != nil {
		return fmt.Errorf("failed marshal soxInfo: %w", err)
	}
	return fileutil.AtomicWrite(path, bytes, 0644, true, false, 0, 0)
}
