package shellutil

import (
	"bufio"
	"os"
)

func Cat(path string) ([]string, error) {
	f, err := os.Open(path)
	if err != nil {
		return nil, err
	}
	defer f.Close()
	rv := make([]string, 0)
	scanner := bufio.NewScanner(f)
	for scanner.Scan() {
		line := scanner.Text()
		rv = append(rv, line)
	}
	if err := scanner.Err(); err != nil {
		return nil, err
	}
	return rv, nil
}
