import logging
import sys

import click

from infra.rtc.notifyctl.lib.script import prepare_app, send_app


def logger_setup(level):
    logger = logging.getLogger()
    logger.setLevel(logging.getLevelName(level))
    handler = logging.StreamHandler(sys.stdout)
    handler.setLevel(logging.DEBUG)
    handler.setFormatter(logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s'))
    logger.addHandler(handler)
    logging.info('Script started')


@click.group()
@click.option('-l', default='info', help='log level')
def notifyctl(l):
    logger_setup(l.upper())
    pass


@notifyctl.command(help='Prepare notifications script')
@click.option('-f', help='Read spec from file', required=True)
@click.option('-u', help='username')
@click.pass_context
def prepare(ctx, f, u):
    try:
        err = prepare_app(f, user=u)
    except KeyboardInterrupt:
        raise SystemExit(0)
    if err is not None:
        print(err)
        raise SystemExit(1)
    raise SystemExit(0)


@notifyctl.command(help='Send notifications script')
@click.option('-b', help='Send batch id', required=True)
@click.pass_context
def send(ctx, b):
    try:
        err = send_app(batch_id=b)
    except KeyboardInterrupt:
        raise SystemExit(0)
    if err is not None:
        print(err)
        raise SystemExit(1)
    raise SystemExit(0)
