import jinja2

from infra.rtc.notifyctl.lib import TEMPLATE_PATH
from infra.rtc.notifyctl.lib.utils import merge_hostnames

templateLoader = jinja2.FileSystemLoader(searchpath=TEMPLATE_PATH)
templateEnv = jinja2.Environment(loader=templateLoader)
templateEnv.filters['merge_hostnames'] = merge_hostnames


def get_template(template_name):
    return templateEnv.get_template(template_name)
