import os
from base64 import urlsafe_b64encode
from time import time

import paramiko

import requests

from infra.rtc.notifyctl.lib import TVM_ID, TVM_URL


def make_signs(data):
    res = []
    for key in paramiko.Agent().get_keys():
        res.append(str(urlsafe_b64encode(key.sign_ssh_data(data)), 'ascii'))
    return res


def get_service_ticket(user=None):
    login = user or os.getlogin()
    timestamp = int(time())
    payload = '{}|{}|{}'.format(timestamp, TVM_ID, TVM_ID)
    for signed_payload in make_signs(payload):
        data = {
            'grant_type': 'sshkey',
            'src': TVM_ID,
            'dst': TVM_ID,
            'login': login,
            'ts': timestamp,
            'ssh_sign': signed_payload
        }
        resp = requests.post(TVM_URL, data='&'.join('{}={}'.format(key, value) for key, value in data.items()))
        try:
            resp.raise_for_status()
        except Exception:
            continue
        return resp.json()[TVM_ID]['ticket']
    raise Exception('no ssh key found')
