{%- set path = "kernel" %}
{%- import_yaml [path, "hostctl.yaml"]|join('/') as hostctl %}
{%- set kernel = hostctl.version %}

{# We have hellish logic around kernel command line and it goes like this #}
{%- set kernel_cmdline = [] %}
{# # Include cmdline modifiers, each will append to the kernel_cmdline list # #}
{#- Hosts for market and yabs should have mitigations enabled #}
{%- if not ('yabs' in grains.walle_tags or 'market' in grains.walle_tags) %}
    {%- include [path, "cmdline-mitigations.jinja"]|join('/') -%}
{%- endif %}
{# Override iommu settings for AMD #}
{%- if 'AMD' in grains.cpu_model %}
  {%- include [path, "cmdline-amd.jinja"]|join('/') -%}
{%- endif %}
{# Enable PSI by default https://st.yandex-team.ru/KERNEL-620 #}
{%- set kernel_psi_enabled = 1 %}
{%- include [path, "cmdline-psi.jinja"]|join('/') -%}
{# Disable multipath for precise: RTCNETWORK-300 #}
{# Disable multipath for xenial: RUNTIMECLOUD-16278 TODO: should be fixed in hw_watcher#}
{%- include [path, "cmdline-multipath.jinja"]|join('/') -%}
{# Enable iommu settings for QYP/GPU hosts #}
{%- if 'rtc.gpu-vfio' in grains['walle_tags'] or grains.walle_project in [
    'rtc-gpu-mtn-prestable',
    'rtc-yt-hahn-gpu-prestable',
    'yp-gpu-sas-dev-prestable',
    'yp-gpu-iva-dev',
    'yp-gpu-man-dev',
    'yp-gpu-myt-dev',
    'yp-gpu-sas-dev',
    'yp-gpu-vla-dev',
] %}
  {%- if 'AMD' in grains.cpu_model %}
    {%- include [path, "cmdline-iommu-amd.jinja"]|join('/') -%}
  {%- elif 'Intel' in grains.cpu_model %}
    {%- include [path, "cmdline-iommu-intel.jinja"]|join('/') -%}
  {%- endif %}
{%- endif %}


{# Now we have "kernel_cmdline" variable, include grub subroutine #}
{%- include [path, "grub.jinja"]|join('/')-%}
{# Now we include cleaner #}
{%- include [path, "purger.jinja"]|join('/') -%}

{# set desired version if we have managed bootloader #}
/var/lib/ya-salt/kernel.yaml:
  file.managed:
    - name: 
    - mode: 644
    - user: root
    - group: root
    - contents: |+
        version: "{{kernel}}"
    - require:
      - /etc/default/grub
      - update_grub

