{%- set path = 'porto-default' %}
{# Make GPU devices available to containers RUNTIMECLOUD-7681 #}
{%- set additional_configs = []  %}
{%- if salt['file.directory_exists']('/etc/portod.conf.d/') %}
    {%- set current_additional_configs = salt['file.readdir']('/etc/portod.conf.d/') %}
{%- else %}
    {%- set current_additional_configs = [] %}
{%- endif %}

/etc/default/portod.conf:
  file.managed:
    - name: /etc/default/portod.conf
    - user: root
    - group: root
    - mode: 644
    - source: "salt://{{ path }}/portod.conf"

{%- for file in additional_configs %}
/etc/portod.conf.d/{{ file }}:
  file.managed:
    - user: root
    - group: root
    - mode: 644
    - makedirs: True
    - template: jinja
    - source: "salt://{{ path }}/portod.conf.d/{{ file }}.jinja"
{%- endfor %}

{%- for f in current_additional_configs %}
    {%- if f not in additional_configs %}
        {%- if f not in ['.', '..'] %}
/etc/portod.conf.d/{{ f }}:
  file.absent:
    - name: /etc/portod.conf.d/{{ f }}
        {%- endif %}
    {%- endif %}
{%- endfor %}
