#!/usr/bin/env python2.7

# this tool cleans out files which do not have corresponding symlinks in apt archives directory
# it should be launched daily after standard apt cleaner

import os
import argparse
import logging


APT_ARCHIVES_DIR = '/var/cache/apt/archives'
SKY_ARCHIVES_DIR = '/var/cache/apt/archives/sky'


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--debug', action='store_true', default=False)
    args = parser.parse_args()
    log_level = logging.INFO
    if args.debug:
        log_level = logging.DEBUG
    logging.basicConfig(format='%(asctime)s [%(levelname)-4.4s](%(process)d) %(name)s: %(message)s', level=log_level)
    logging.info('starting apt-sky archives cleaner')
    linked_files = []
    logging.info('scanning %s for missing links to %s', APT_ARCHIVES_DIR, SKY_ARCHIVES_DIR)
    for entry in os.listdir(APT_ARCHIVES_DIR):
        file_path = os.path.join(APT_ARCHIVES_DIR, entry)
        if os.path.islink(file_path):
            link_path = os.readlink(file_path)
            logging.debug('found symlink: %s -> %s', file_path, link_path)
            if link_path.startswith(SKY_ARCHIVES_DIR):
                logging.info('found sky link: %s', link_path)
                linked_files.append(link_path)
    logging.info('finished reading links')
    logging.debug('found sky links: %s', str(linked_files))
    logging.info('checking missing links and cleaning up')
    for entry in os.listdir(SKY_ARCHIVES_DIR):
        file_path = os.path.join(SKY_ARCHIVES_DIR, entry)
        logging.debug('checking link to: %s', file_path)
        if not file_path in linked_files:
            logging.info('link to %s is missing, deleting file', file_path)
            os.unlink(file_path)
        else:
            logging.debug('link to %s present, skipping file', file_path)
    logging.info('finished cleanup')


if __name__ == '__main__':
    main()
