%define deb_version %{expand:%%(awk -F'"|-' '/version/ {print $4}' pkg.json)}
%define release_version %{expand:%%(ya svn --detect info | awk '/^Last Changed Rev:/ {print $NF}')}

Summary: Host based firewall agent init
Name: yandex-hbf-agent-init
Version: %deb_version
Release: %release_version
License: proprietary
Group: System Environment/Base
Vendor: yandex
Packager: askort@yandex-team.ru
BuildRoot: %_tmppath/%name-%version-%release-root
BuildArch: noarch
URL: https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/packages/yandex-hbf-agent-init
Requires: yandex-hbf-agent
Source: %name.tar.gz

%if 0%{?el7} || 0%{?el8}
%systemd_requires
%endif

%description
Host based firewall agent init

%prep
%setup -n %name

%install
rm -rf $RPM_BUILD_ROOT
%if 0%{?el7} || 0%{?el8}
install -d -m 755 $RPM_BUILD_ROOT/%{_unitdir}
install -d -m 755 $RPM_BUILD_ROOT/%{_tmpfilesdir}
install -m 644 systemd/yandex-hbf-agent.service \
        $RPM_BUILD_ROOT/%{_unitdir}/yandex-hbf-agent.service
install -m 644 systemd/tmpfiles.d/yandex-hbf-agent.conf \
        $RPM_BUILD_ROOT/%{_tmpfilesdir}/yandex-hbf-agent.conf
%else
install -d -m 755 $RPM_BUILD_ROOT/etc/init/
install -m 644 upstart/yandex-hbf-agent.el6.conf \
        $RPM_BUILD_ROOT/etc/init/yandex-hbf-agent.conf
install -m 644 upstart/yandex-hbf-agent-pre.conf \
        $RPM_BUILD_ROOT/etc/init/yandex-hbf-agent-pre.conf
%endif

%files
%if 0%{?el7} || 0%{?el8}
%{_unitdir}/yandex-hbf-agent.service
%{_tmpfilesdir}/yandex-hbf-agent.conf
%else
%config /etc/init/yandex-hbf-agent.conf
%config /etc/init/yandex-hbf-agent-pre.conf
%endif

%post
%if 0%{?el7} || 0%{?el8}
%systemd_post yandex-hbf-agent.service
%tmpfiles_create %{_tmpfilesdir}/yandex-hbf-agent.conf
%else
/sbin/initctl reload-configuration
%endif

%if 0%{?el7} || 0%{?el8}
%postun
%systemd_postun
%endif

%changelog
