# ХБФ агент

Данный агент предназначен для поддержания на хосте централизованно управляемого
списка правил фаервола с возможностью добавления статических или динамических
локальных правил.


##  Принцип работы:
1. Собираем список ip адресов на машине (хуки `host_ips` и `guest_ips` в
   [конфигурационном файле](#options)). Загружаем статические цели из файла
   `targets.list` если таковой существует.
2. Находим все локальные правила записанные в файлах `rules.d/*.{v4,v6}`.
3. Запрашиваем правила для найденых адресов и других целей с
   [ХБФ сервера][XБФ сервер].  В случае возникновения ошибок используем правила
   полученные на прошлой итерации или пустой набор.
4. Все собранные правила склеиваем в одну простыню.
5. Новый набор правил сравниваем с тем, что мы сгенерировали на прошлой
   итерации, eсли они отличаются - применяем новые правила. Правила применяются
   в режиме `--noflush`, в результате чего у нас может остаться множество
   неактуальных цепочек. Такие цепочки удаляются с помощью ГЦ.
6. Ждем таймер. Если сконфигурировано, то собираем адреса с контейнеров или
   виртуальных машин запущенных на данном хосте (хук `guest_ips`). Если
   появились новые адреса - переходим к новой итерации не дожидаясь окончания
   таймера.

[XБФ сервер]: https://hbf.yandex.net


## Конфигурация

Выполняемый файл агента называется `yandex-hbf-agent`. Агент читает
конфигурацию из `/etc/yandex-hbf-agent/yandex-hbf-agent.conf` (опция командной
строки `--config`) и конфигурацию по умолчанию из
`/usr/share/yandex-hbf-agent/yandex-hbf-agent.configspec` (опция командной
строки `--configspec`). Значения полученые по первому пути переопределяют
значения полученные по второму пути. Рядом с конфигурационным файлом, в
директории `rules.d`, лежит набор правил, который тоже является частью
конфигурации. Опциональный набор статических целей может задаваться в файле
`targets.list` в директории с конфигом.


### Опции (yandex-hbf-agent.conf) <a name="options"></a>

Конфиг агента хранится в формате `INI`. Для генерации и загрузки используется
[configobj][configobj].

Обратите внимание, что `yandex-hbf-agent.conf` это просто конфигурационный
файл, а в `yandex-hbf-agent.configspec` это т.н. конфигспек. Кроме значений по
умолчанию, он содержит также типы ключей для валидации. Опции агента
задокументированы в [конфигспеке][configspec].

Чтобы увидеть конфиг агента по умолчанию без типов, воспользуйтесь опцией
командной строки `--default-config`. Чтобы увидеть текущую конфигурацию с
учётом умолчаний и переопределений, воспользуйтесь опцией командной строки
`--current-config`.

[configobj]: http://www.voidspace.org.uk/python/configobj.html
[configspec]: https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/packages/yandex-hbf-agent/share/yandex-hbf-agent.configspec


### Локальные правила (rules.d)

Кроме конфигурационного файла, агент загружает локальные правила из директории
`rules.d` находящейся в тех же директориях где лежат конфиги. Сначала
загружеются все файлы из директории с конфигом, после чего загружаются все
файлы из директории с конфигспеком. Если файл с определённым именем был
загружен из первой директории, то он пропускается при загрузке из второй
директории. Это позволят переопределять (или совсем отключать) умолчальные
правила.

Конфигурация по умолчанию выглядит так:

```
/usr/share/yandex-hbf-agent/
|-- rules.d
|   |-- 10-ssh.v4
|   |-- 10-ssh.v6
|   |-- 20-manual.v4
|   |-- 20-manual.v6
|   |-- 30-iptruler.v4
|   |-- 30-iptruler.v6
|   |-- 50-hbf.v4
|   `-- 50-hbf.v6
`-- yandex-hbf-agent.configspec
```

Файлы c правилами хранятся в формате `iptables-save`. Например файл
`50-hbf.v6`:

```
*filter
:Y_FW -
:Y_FW_OUT -
-A INPUT -j Y_FW
-A FORWARD -j Y_FW
-A FORWARD -j Y_FW_OUT
-A OUTPUT -j Y_FW_OUT
COMMIT
```

Данный файл определяет цепочки `Y_FW` и `Y_FW_OUT` c деревьями правил
ХБФ. Кроме того, он определяет прыжок в данные цепочки из встроенных
цепочек. Сами правила для цепочек `Y_FW` и `Y_FW_OUT` будут получены от ХБФ
сервера.

Обратите внимание, что данные правила абсолютно необходимы для нормальной
работы ХБФ-а и мы не рекомендуем их переопределять!

Если вы например хотите отключить ХБФ для исходящего трафика, то лучше убрать
параметр запроса `output` в опции `server_options`. Сервер при этом не будет
возвращать никаких правил в цепочке `Y_FW_OUT` и она останется пустой.

#### Защищённые цепочки

В процессе работы агент удаляет все правила, кроме своих. Иногда администратору
необходимо добавить некоторые правила вручную или с использованием стороннего
процесса. Для этого в конфигурации агента предусмотрены "защищённые
цепочки". Работа с ними организована просто: агент пытается создать такие
цепочки, в случае, если их нет в момент применения правил, и больше не трогать.

Вот пример защищённой цепочки для правил добавляемых руками:

```
*filter
# Yandex-HBF-Agent: protected
:MANUAL -
-A INPUT -j MANUAL
COMMIT
```

Комментарий `# Yandex-HBF-Agent: protected` прменяется к строке следующей
за ним и конфигурирует цепочку `MANUAL` как защищённую. Дальше добавляется
прыжок из встроенной цепочки `INPUT` в защищённую цепочку `MANUAL`. При такой
конфигурации можно вручную добавлять правила для входящего трафика в цепочку
`MANUAL` и агент не будет их удалять.

Более сложный пример, для программы `iptruler`:

```
# Yandex-HBF-Agent: protected
*filter
:IPTRULER -
:SLB -
-A INPUT -j IPTRULER
COMMIT
```

В данном случае за комментарием следует определение таблицы `filter`. Это
означает, что все цепочки определённые для данной таблицы (до директивы
`COMMIT`) будут сконфигурированы как защищённые.

Обратите внимание, что нет смысла добавлять в конфигурации агента какие-либо
правила в защищённые цепочки, т.к. при применении цепочки с правилами она
сначала очищается, а потом в неё добавляются сконфигурированные правила. При
обнаружении правил в защищённых цепочках агент выводит в лог предупреждающее
сообщение.


### Статические цели

Агент поддерживает конфигурацию статических целей. Список строк, которые всегда
будут передаваться в запросе к серверу можно задать в файле `targets.list`
рядом с основным конфигом агента. Пустые строки и строки начинающиеся с "#" --
пропускаются. Остальные строки могут содержать всё, что поддерживает
[сервер][сервер]. В частности, туда можно записать список идентификаторов
проектов, которые могут запускаться на данном хосте. Тогда фаервол для них
будет готов всегда и не придётся ждать итерации агента для начала
работы. Формат для такой цели: `pid:_FIREWALL_MACRO_`.

[сервер]: https://hbf.yandex.net


### Логирование

Агент конфигурирует логирование с помощью стандартной процедуры
[dictConfig][dictConfig]. Словарь описывается в конфигурационном файле
`logging.conf`. Формат конфига - `INI`, но, в отличие от основного конфига,
значения опций здесь нужно писать как питоновые литералы. Т.е. числа - просто
так, строчки - в кавычках, списки - в квадратных скобках. Подробнее об этом
режиме работы с конфигом можно прочитать [здесь][unrepr]. Как и в случае с
основным конфигом, файл в `/etc/yandex-hbf-agent` переопределяет значения по
умолчанию из `/usr/share/yandex-hbf-agent`. [Конфиг по умолчанию][logging.configspec] включает
логирование в стандартный поток ошибок. Вот пример конфигурации для логирования
в `journald` (для работы необходимо установить модуль `systemd`):

```
[root]
handlers = ["root_handler"]

[handlers]
[[root_handler]]
class = "systemd.journal.JournalHandler"
SYSLOG_IDENTIFIER = "yandex-hbf-agent"
formatter = "root_formatter"

[formatters]
[[root_formatter]]
format = "%(name)-17s  %(levelname)-8s  %(message)s"
```

[dictConfig]: https://docs.python.org/2.7/library/logging.config.html#logging.config.dictConfig
[unrepr]: http://www.voidspace.org.uk/python/configobj.html#unrepr-mode
[logging.configspec]: https://a.yandex-team.ru/arc/trunk/arcadia/infra/rtc/packages/yandex-hbf-agent/share/logging.configspec


## Запуск и остановка агента

Пакет `yandex-hbf-agent-init` включает в себя конфигурацию для Апстарта и
СистемД. Сервис называется `yandex-hbf-agent`. Для запуска и остановки
воспользуйтесь стандартными командами.

После запуска агент ждёт случайное время в интервале от 0 до
`update_period_random` (по умолчанию -- 10 с.), и только после этого приступает
к выполнению итерации. Это сделано для того, чтобы избежать одновременного
похода десятков тысяч агентов в ХБФ сервер.

В процессе остановки агент не удаляет никаких правил. Для удаления прыжка в
дерево правил ХБФ у запускаемого файла агента есть опция командной строки
`--disable-hbf`.

Обратите внимание, что для удаления прыжка в дерево ХБФ агент пытается удалить
правила определённые в файлах `50-hbf.v4` и `50-hbf.v6`. Если вы перенесли
данный прыжок в другой файл с правилами это не сработает.


## Принудительное обновление правил

Для принудительного обновления правил можно воспользоваться командой инита
`reload` или послать агенту сигнал `HUP`. Что при этом происходит:
- Текущая или ближайшая фаза ожидания прерывается. Запускается новая итерация.
- Перезагружается конфиг.
- Агент забывает последнее значение `Last-Modified` которое ему возвращал
  сервер.
- Далее итерация выполняется как обычно.


## Экстренное отключение агента

В экстренной ситуации агента можно временно приостановить создав файл
`/var/run/yandex-hbf-agent/disabled` (опция `disabling_flag`). После
обнаружения файла агент удаляет прыжок в дерево ХБФ и остаётся в фазе ожидания
до тех пор, пока этот файл будет оставаться на ФС.

Обратите внимание, что для удаления прыжка в дерево ХБФ агент пытается удалить
правила определённые в файлах `50-hbf.v4` и `50-hbf.v6`. Если вы перенесли
данный прыжок в другой файл с правилами это не сработает.


## Логирование

Агент пишет логи в `stderr`. На системе с Апстартом логи можно найти в
`/var/log/upstart/yandex-hbf-agent.log`. На системе с СистемД логи можно
почитать с помощью `journalctl -u yandex-hbf-agent`.

Дамп текущего состояния агента можно получить послав ему сигнал `USR1`. В лог
будет выведен текущий конфиг, а также несколько наборов правил.


## ХТТП интерфейс

ХТТП интерфейс агента по умолчанию доступен по адресу
`http://localhost:9876`. Список ручек:

- `/status` - Возвращает JSON объект с полями `status`, `desc` и
  `last_update`. Первые два соответствуют аналогичным полям в Джагглере (только
  `status` выводится в текстовом виде). `last_update` показывает время
  последнего обновления данных в ручке. Выводимые данные соответствуют
  последней _завершённой_ итерации, т.е. в процессе выполнения итерации агент
  накапливает ошибки и по окончании публикует их в этой ручке. Используется
  скриптом [мониторинга](#monitoring).
- `/ip_address_ready` - Принимает на вход единственный параметр --
  `ip`. Возвращает ХТТП статус 200 если фаервол для данного адреса применён и
  404 если нет. Используется ISS агентом, чтобы не запускать контейнеры пока
  для них не применён фаервол.


## Мониторинг <a name="monitoring"></a>

Для мониторинга агента используется Джагглер [скрипт][скрипт]. Список проверок:

1. Наличие правил с целью `NOTRACK` (специфика поискового облака, в будущем
   это проверка будет опциональной).
2. Пакет установлен.
3. Процесс запущен.
4. Статус агента доступный через ХТТП интерфейс.
5. ГЦ не удаляет защищённые цепочки.

[скрипт]: https://svn.yandex-team.ru/monitor/trunk/yandex-farm/projects/monitoring/monitoring-only/search/home/monitor/agents/modules-available/check_hbf.py


# Поиск сработавших правил (hbf-trace)

`hbf-trace` позволяет найти в дереве правил совпадения по айпи-адресу
источника, порту назначения и протоколу. Работает на локальной машине выгружаая
актуальный набор правил из iptables соответствующей (`v4`/`v6`)
версии. Трассировка не очень интеллектуальная и позволяет показать все правила
которые потенциально могут сработать, а также выделяет цветом правила со
специальными целями - `LOG`, `ACCEPT`, `REJECT` и `DROP`.

```
usage: hbf-trace [-h] [-t TABLE] [-c CHAIN] [-p DPORT]
                 [--proto {tcp,udp,icmp,ipv6-icmp,ipencap,any}]
                 [--log-level {debug,info,warning,error,critical}]
                 [--debug | --full-tree]
                 ip

positional arguments:
  ip                    source IP address to trace in iptables tree

optional arguments:
  -h, --help            show this help message and exit
  -t TABLE, --table TABLE
                        table name to trace in (default: filter)
  -c CHAIN, --chain CHAIN
                        Chain name to begin trace in (default: INPUT)
  -p DPORT, --dport DPORT
                        destination port number
  --proto {tcp,udp,icmp,ipv6-icmp,ipencap,any}
                        protocol name (default: any)
  --log-level {debug,info,warning,error,critical}
                        log level (default: error)
  --debug               show content of all visited chains
  --full-tree           show entire tree
```

Есть три режима вывода, отличающиеся детализацией:
- По умолчанию: выводятся только совпадения.
- Полное дерево (`--full-tree`): содержит все найденые в дереве
  правила. Может быть удобен для просмотра под-дерева.
- Отладочный (`--debug`): выводятся все правила которые были проверены в ходе
  поиска.

Цвета:
- Синий - совпадения (только в режимах `--full-tree` и `--debug`).
- Зеленый - совпадения с целью `ACCEPT`.
- Желтый - совпадения с целью `LOG`.
- Красный - совпадения с целью `DROP` или `REJECT`.
