package cmd

import (
	"log"

	"github.com/spf13/cobra"
)

const (
	defGoMaxProc = 4
	defVanila    = false
)

var vanila bool
var gomaxprocs int

var rootCmd = &cobra.Command{
	Use:   "hbf-metrics-pusher",
	Short: "Pushes drops per service to solomon",
	Long: `hbf-metrics-pusher will parse iptables, determine services with drops,
and push packet drop couneters per service to solomon`,
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		log.Fatalf("%v", err)
	}
}
func init() {
	rootCmd.PersistentFlags().BoolVar(&vanila, "vanila", defVanila, "use vanila iptables")
	rootCmd.PersistentFlags().IntVar(&gomaxprocs, "gomaxprocs", defGoMaxProc, "tweak GOMAXPROCS, used in 'serve' mode only for now")
}
