package netwrap

import (
	"net"
)

// TryParseIP parses ipn as IP address OR as CIDR notation IP address and prefix length, returning result.
// The string ipn can be in IPv4 dotted decimal ("192.0.2.1"), IPv6
// ("2001:db8::68"), IPv4-mapped IPv6 ("::ffff:192.0.2.1"), or in CIDR form,
// like "192.0.2.0/24" or "2001:db8::/32", as defined in RFC 4632 and RFC 4291.
// If s is not a valid textual representation of an IP address, TryParseIP returns *net.ParseErrror.
func TryParseIP(ipn string) (string, error) {
	nip := net.ParseIP(ipn)
	if nip != nil {
		return nip.String(), nil
	}
	_, nn, err := net.ParseCIDR(ipn)
	if err != nil {
		return "", err
	}
	return nn.String(), nil
}
