package solomon

import (
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

const (
	ClientTimeout = 2
	PushURL       = "https://solomon.yandex.net/api/v2/push"

	VaultSecretID = "sec-01febn8v69yg3v7hejwkwr9zvk"
	SecretKey     = "client_secret"
	HostCert      = "/etc/certs/capi.pem"

	Project = "hbf-per-service-drops"
	Cluster = "production"
	Service = "srv"

	TvmMyselfID  = 2030177 // https://nda.ya.ru/t/-UvR8eMg4Cciwx
	TvmSolomonID = 2010242 // https://nda.ya.ru/t/pI3HvlRw4CcjYW
	TvmCacheDir  = "/run/hbf-metrics-pusher/tvm"
)

type SecretsCfg struct {
	VaultID    string
	StorageKey string
	HostCert   string
}

type SolomonCfg struct {
	URL     string
	Cluster string
	Project string
	Service string
	Timeout time.Duration
}

type TvmCfg struct {
	MyselfID  tvm.ClientID
	CacheDir  string
	SolomonID tvm.ClientID
}

type Config struct {
	Secrets SecretsCfg
	Solomon SolomonCfg
	Tvm     TvmCfg
}
