// There is no any proto scheme for solomon pushes format.
// So invent it by ourselves
package solomon

import "go.uber.org/zap/zapcore"

/*
{
  "ts": "string",
  "commonLabels": "object",
  "metrics": [
    {
      "labels": "object",
      "type": "string",
      "mode": "string",
      "memOnly": true,
      "ts": "string",
      "value": "number",
      "hist": {
        "bounds": "object",
        "buckets": "object",
        "inf": "number"
      },
      "timeseries": [
        {
         "ts": "string",
         "value": "number"
        }
      ]
    }
  ]
}
*/

type JSONFormat struct {
	// in original, this filed can be string with ISO-8601 timestamp, or int with UNIX time, we use int64
	TS           int64             `json:"ts"`
	CommonLabels map[string]string `json:"commonLabels"`
	Metrics      []Metric          `json:"metrics"`
}

// We won't use all fields from original format, because we don't need them for now, or if they are deprecated
type Metric struct {
	Labels map[string]string `json:"labels"`
	Type   string            `json:"type"`
	TS     int64             `json:"ts"`
	Value  uint64            `json:"value"` // in our case, we push numbers of droped packets
}

func NewCounter() Metric {
	return Metric{Type: "COUNTER", Labels: make(map[string]string)}
}

func NewIgauge() Metric {
	return Metric{Type: "IGAUGE", Labels: make(map[string]string)}
}

func (m Metric) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddString("Type", m.Type)
	enc.AddInt64("TS", m.TS)
	enc.AddUint64("Value", m.Value)
	return enc.AddReflected("Labels", m.Labels)
}
