import requests
import logging
import socket
import json

from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry


SERVER_INFO_PATH = '/etc/server_info.json'
TIMEOUT = 5.0
RETRY_LIMIT = 5
APPLY_SERVICE = 'hbf-rules-apply'
VALID_SERVICE = 'hbf-rules-validation'
DROP_SERVICE = 'hbf-drop-buckets'
TAGS = ['hbf-agent']


def push(status, desc, service, tags):
    events = {
        "events": [
            {
                "host": socket.gethostname(),
                "service": service,
                "instance": "",
                "status": status,
                "description": desc,
                "tags": tags,
            }
        ]
    }
    try:
        with requests.Session() as s:
            retries = Retry(
                total=RETRY_LIMIT,
                read=RETRY_LIMIT,
                connect=RETRY_LIMIT,
                backoff_factor=0.5,
                status_forcelist=[500, 502, 503, 504],
                method_whitelist=frozenset(['POST'])
            )
            s.mount('http://', HTTPAdapter(max_retries=retries))
            s.post("http://[::1]:31579/events", json=events, timeout=TIMEOUT)
    except Exception:
        logging.exception("juggler request failed")


def push_ruleset_crit():
    tags = [APPLY_SERVICE]
    tags.extend(TAGS)
    push(
        'CRIT',
        'New ruleset is much smaller than previous! Enable ORLY',
        APPLY_SERVICE,
        tags,
    )


def push_ruleset_ok():
    tags = [APPLY_SERVICE]
    tags.extend(TAGS)
    push(
        'OK',
        '',
        APPLY_SERVICE,
        tags,
    )


def push_validation_crit(msg):
    tags = [VALID_SERVICE]
    tags.extend(TAGS)
    push(
        'CRIT',
        msg,
        VALID_SERVICE,
        tags,
    )


def push_validation_warn(msg):
    tags = [VALID_SERVICE]
    tags.extend(TAGS)
    push(
        'WARN',
        msg,
        VALID_SERVICE,
        tags
    )


def push_validation_ok():
    tags = [VALID_SERVICE]
    tags.extend(TAGS)
    push(
        'OK',
        '',
        VALID_SERVICE,
        tags,
    )


def push_drops_ok():
    tags = [DROP_SERVICE]
    tags.extend(TAGS)
    push(
        'OK',
        '',
        DROP_SERVICE,
        tags
    )


def push_drops_crit(msg, in_tags):
    tags = [DROP_SERVICE]
    tags.extend(TAGS)
    tags.extend(in_tags)
    push(
        'CRIT',
        msg,
        DROP_SERVICE,
        tags
    )


def get_geo(server_info_path=SERVER_INFO_PATH):
    try:
        with open(server_info_path) as f:
            server_info = json.load(f)
        return server_info.get('walle_dc')
    except Exception as e:
        logging.info('Could not determine geo tag: {}'.format(e))
    return None
