class Ugram(object):
    def __init__(self, val=0, buckets=None):
        self.def_buckets = (0, 1, 6, 60, 600, 6000, 60000)
        self.val = val if val >= 0 else 0
        self.prev_val = 0
        if not buckets:
            buckets = self.def_buckets
        buckets = sorted(buckets)
        self.buckets = [[b, 0] for b in reversed(buckets)]

    def update(self, val):
        self.prev_val = self.val
        self.val = val

    @property
    def value(self):
        diff = self.val - self.prev_val
        if diff < 0:
            diff = self.val
        hit = False
        for b in self.buckets:
            if diff >= b[0] and not hit:
                b[1] = 1
                hit = True
            else:
                b[1] = 0
        return [b for b in reversed(self.buckets)]
