import re
import subprocess


re_inet_addr = re.compile(
    r"(?P<index>\d+):\s+(?P<ifname>.*?)\s+inet6?\s+(?P<addr>.*?)\s+"
)

re_link = re.compile(
    r"(?P<index>\d+):\s+(?P<ifname>.*?):\s+(?P<details>.*)"
)


def run():
    ips = set()
    dummies = set()

    link_out = subprocess.check_output(["ip", "-d", "-o", "link", "list"])
    for line in link_out.splitlines():
        m = re_link.match(line)
        if not m:
            continue

        if "dummy" in m.group("details"):
            dummies.add(m.group("ifname"))

    ip_out = subprocess.check_output(["ip", "-o", "addr", "show", "scope", "global"])
    for line in ip_out.splitlines():
        m = re_inet_addr.match(line)
        if not m:
            continue

        if m.group("ifname") not in dummies:
            continue

        ips.add(m.group("addr").split("/")[0])
    return ips

if __name__ == "__main__":
    print run()
