import re
import subprocess


re_inet_addr = re.compile(
    r"\d+:\s+(?P<ifname>.*?)\s+inet6?\s+(?P<addr>.*?)\s+.*?scope\s+global"
)


def run():

    def regular_interface():
        ifname = m.group("ifname")
        return ifname != "lo" and not ifname.startswith("dummy")

    ips = set()

    ip_out = subprocess.check_output(["ip", "-o", "addr"])
    for line in ip_out.splitlines():
        m = re_inet_addr.match(line)
        if m and regular_interface():
            addr_str = m.group("addr")
            addr = addr_str.split("/")[0]
            ips.add(addr)

    return ips
