import re
import subprocess


re_inet_addr = re.compile(
    r"(?P<index>\d+):\s+(?P<ifname>.*?)\s+inet6?\s+(?P<addr>.*?)\s+"
)

re_link = re.compile(
    r"(?P<index>\d+):\s+(?P<ifname>.*?):\s+"
)


def run():
    ips = set()
    lo_ifaces = set()

    link_out = subprocess.check_output(["ip", "-o", "link", "list"])
    for line in link_out.splitlines():
        if "link/loopback" not in line:
            continue

        m = re_link.match(line)
        if m:
            lo_ifaces.add(m.group("ifname"))

    ip_out = subprocess.check_output(["ip", "-o", "addr", "show", "scope", "global"])
    for line in ip_out.splitlines():
        m = re_inet_addr.match(line)
        if not m:
            continue

        if m.group("ifname") not in lo_ifaces:
            continue

        ips.add(m.group("addr").split("/")[0])
    return ips

if __name__ == "__main__":
    print run()
