import socket
import subprocess
import json

from hbfagent.config import Config


def run():
    conf = Config()['k8s']
    res = subprocess.check_output(
        ["kubectl", "get", "pods", "-A", "-o", "json"],
        env={
            'KUBECONFIG': conf.get('kubeconfig', '/etc/kubernetes/kubelet.conf'),
            'KUBECONTEXT': conf.get('context', 'default')
        }
    )
    data = json.loads(res)
    hostname = socket.gethostname()
    ips = [i['status']['podIP'] for i in data['items'] if i['spec']['nodeName'] == hostname]
    return set(ips)
