import errno
import logging
import os


BASEDIR = '/var/lxc/root/'
INTERFACES = 'rootfs/etc/network/interfaces'


log = logging.getLogger(__name__.split(".")[-1])
log.addHandler(logging.NullHandler())


def run():
    ips = set()

    vms = os.listdir(BASEDIR)

    for host in vms:
        filename = os.path.join(BASEDIR, host, INTERFACES)

        try:
            with open(filename, 'r') as file:
                for line in file:
                    line = line.strip()
                    line = line.split()
                    if len(line) > 1 and line[0] == 'address':
                        ips.add(line[1])

        except Exception as error:
            if isinstance(error, IOError) and error.errno == errno.EACCES:
                continue
            log.exception("Exception:")

    return ips
