import logging
import os
import subprocess

from hbfagent import netns


LXC_LS = '/usr/bin/lxc-ls'
LXC_INFO = '/usr/bin/lxc-info'
IP = '/sbin/ip'

log = logging.getLogger(__name__.split(".")[-1])
log.addHandler(logging.NullHandler())


def run():
    ips = set()

    if os.geteuid() != 0:
        log.error(
            "This module must be running with root permissions, exiting."
        )
        return ips

    try:
        vms = subprocess.check_output([LXC_LS, '-1', '--running']).splitlines()
    except subprocess.CalledProcessError:
        log.exception("Unable to get list of LXC containers:")
        return ips

    for vm in vms:

        try:
            vmpid = subprocess.check_output(
                [LXC_INFO, '-n', vm, '--pid', '--no-humanize']).rstrip()
        except subprocess.CalledProcessError:
            log.exception(
                "Unable to get init PID for LXC container '{}':".format(vm)
            )
            continue

        try:
            with netns.NetNS(nspid=int(vmpid)):
                try:
                    cmd = [IP, 'address', 'show', 'scope', 'global', 'up']
                    addresses = subprocess.check_output(cmd).splitlines()
                except subprocess.CalledProcessError:
                    msg = "Error while running '{}' in LXC container '{}':"
                    msg = msg.format(IP, vm)
                    log.exception(msg)
                    continue
        except (OSError, ValueError):
            log.exception(
                "Unable to enter network namespace of PID {}:".format(vmpid)
            )
            continue

        for line in addresses:
            elem = line.split()
            if elem[0] == 'inet' or elem[0] == 'inet6':
                ips.add(elem[1].split('/')[0])

    return ips
