import time
import logging
import pylxd

from hbfagent.config import Config
from hbfagent.util import list_from_csv


LOG = logging.getLogger(__name__.split(".")[-1])
LOG.addHandler(logging.NullHandler())

CACHE = None
CACHED_UNTIL = 0


def get_client(config):
    client = pylxd.Client(endpoint=config['url'],
                          cert=list_from_csv(config['cert']), verify=False,
                          timeout=tuple(list_from_csv(config['timeout'], int)))
    client.authenticate(config['password'])
    return client


def get_global_addrs(container_network):
    result = set()
    if container_network is not None:
        for iface, iface_data in container_network.items():
            if 'eth' in iface:
                for addr in iface_data['addresses']:
                    if addr['scope'] == 'global':
                        result.add(addr['address'])
    return result


def run():
    global CACHED_UNTIL, CACHE

    config = Config()['lxd_ips']

    if CACHED_UNTIL > time.time():
        LOG.debug('Return cached value: {}'.format(CACHE))
        return CACHE

    LOG.debug('Collecting data from LXD.')
    ips = set()
    client = get_client(config)
    for container in client.containers.all():
        ips |= get_global_addrs(container.state().network)
    CACHE = ips
    CACHED_UNTIL = time.time() + config['cache_ttl']

    return ips
