from hbfagent.config import Config

import porto
import logging
import ipaddr

log = logging.getLogger(__name__.split(".")[-1])
log.addHandler(logging.NullHandler())


def parse_porto_response(prop_strings):
    ips = set()
    for container in prop_strings:
        labels_string = prop_strings[container].get('labels', None)
        skip = False
        if labels_string and isinstance(labels_string, (str, unicode)):
            for label in labels_string.split(';'):
                name, value_str = label.split(':')
                if "HBF.ignore_address" not in name:
                    continue
                try:
                    # E.g. we have pre-configured targets.list
                    value = int(value_str.strip())
                    skip = value > 0
                except ValueError:
                    pass
        if skip:
            continue

        ip_string = prop_strings[container]['ip']
        if not ip_string or not isinstance(ip_string, (str, unicode)):
            continue
        for interface_config in ip_string.split(';'):
            ip_address = interface_config.split()[1]
            try:
                net = ipaddr.IPNetwork(ip_address, strict=False)
            except ValueError:
                msg = "Invalid IP address '{}' in Porto container '{}'."
                log.error(msg.format(ip_address, container))
            else:
                if net.numhosts > 1:
                    ips.add(net)
                ips.add(net.ip)
    return ips


def run():
    config = Config()['porto_ips']
    conn = porto.Connection(timeout=config['porto_timeout'])
    return parse_porto_response(conn.Get(conn.List(), ['ip', 'labels']))
