from hbfagent.config import Config
import json
import logging
import urllib2

import ipaddr
import porto

from hbfagent import util
from hbfagent.mod.porto_ips import parse_porto_response

# Returns instances with TargetState == "ACTIVE"
ISS_INSTANCES_URL = "http://localhost:25536/infra/hbf/v0"


log = logging.getLogger(__name__.split(".")[-1])
log.addHandler(logging.NullHandler())


def run():
    config = Config()["porto_ips_runtime"]
    ips = set()
    iss_ok = False
    porto_ok = False

    try:
        instances = json.loads(
            urllib2.urlopen(ISS_INSTANCES_URL,
                            timeout=config["iss_timeout"]).read()
        )
        iss_ok = True
    except Exception as e:
        log.error("Cannot retrieve instances from ISS: {}".format(e))
        instances = {}

    try:
        conn = porto.Connection(timeout=config["porto_timeout"])
        prop_strings = conn.Get(conn.List(), ["ip", "labels"])
        porto_ok = True
    except Exception as e:
        log.error("Cannot retrieve instances from Porto: {}".format(e))
        prop_strings = []

    if not porto_ok and not iss_ok:
        raise Exception('Neither Porto nor ISS respond with instances')

    log.debug("ISS Instances: {}".format(instances))
    for instance in instances.values():
        try:
            instance_ips = instance["ip"]
            if not instance_ips:
                continue
            iss_hbf_nat = instance["HBF_NAT"]
        except KeyError as e:
            msg = "Key error ({}) in ISS instance '{}'."
            log.debug(msg.format(e, instance))
            continue
        for ip_address in instance_ips:
            try:
                net = ipaddr.IPNetwork(ip_address, strict=False)
            except ValueError:
                msg = "Invalid IP address '{}' in ISS instance '{}'."
                log.error(msg.format(ip_address, instance))
            else:
                ip = net.ip
                if net.numhosts > 1:
                    ips.add(net)

                if isinstance(ip, ipaddr.IPv6Address):
                    ip = util.ISSIPv6Address(
                        ip,
                        iss_hbf_nat=iss_hbf_nat
                    )
                ips.add(ip)
    log.debug("IPS: {}".format(ips))

    if not porto_ok:
        if not ips:
            raise Exception('Porto did not respond and ISS reported zero instances')
        else:
            return ips

    ips.update(parse_porto_response(prop_strings))
    return ips
