import ipaddr
import logging


NET_FILE = "/etc/docker/vertis-networks"

log = logging.getLogger(__name__.split(".")[-1])
log.addHandler(logging.NullHandler())


def run():
    ips = set()

    try:
        with open(NET_FILE) as f:
            for line in f:
                line = line.strip()
                try:
                    net = ipaddr.IPNetwork(line, strict=False)
                    ips.add(net)
                except ValueError:
                    log.error("Invalid IP net '{}'".format(line))
    except Exception as e:
        log.error("Failed to read networks from file: {}".format(e))
        return ips
    return ips
