import os
import ipaddr
import logging
import json


DOCKER_CONFIG = "/etc/docker/daemon.json"
MAXCONTAINERCOUNT = 200


log = logging.getLogger(__name__.split(".")[-1])
log.addHandler(logging.NullHandler())


def run():
    ips = set()

    if os.path.isfile(DOCKER_CONFIG) and os.access(DOCKER_CONFIG, os.R_OK):

        try:
            with open(DOCKER_CONFIG) as f:
                config_data = json.load(f)
                subnet = config_data['fixed-cidr-v6'].split("/")[0]
        except Exception as e:
            log.error("Can not get fixed-cidr-v6: {}".format(e))
            return ips

        address_mask = str(subnet.rsplit(":", 1)[0] + ":")

        for number in range(MAXCONTAINERCOUNT):
            generated_addr = address_mask + str(hex(number).split('x')[-1])

            try:
                ipaddr.IPAddress(generated_addr)
            except ValueError:
                msg = "Invalid IP address '{}'."
                log.error(msg.format(generated_addr))
            else:
                ips.add(generated_addr)

    else:
        msg = "'{}' is missing or not readable."
        log.error(msg.format(DOCKER_CONFIG))

    return ips
