import subprocess
import ipaddr
import logging


MAXCONTAINERCOUNT = 200

log = logging.getLogger(__name__.split(".")[-1])
log.addHandler(logging.NullHandler())


def run():

    ips = set()

    local_addr = subprocess.check_output(
        ["ip", "-6", "addr", "show", "eth0", "scope", "global", "up"]
    ).split("/128")[0].rsplit(" ")[-1]

    address_mask = local_addr.rsplit(":", 2)[0] + ":" + local_addr.rsplit(":")[-1] + ":"

    for number in range(MAXCONTAINERCOUNT):
        generated_addr = address_mask + hex(number).split('x')[-1]
        try:
            ipaddr.IPAddress(generated_addr)
        except ValueError:
            msg = "Invalid IP address '{}'."
            log.error(msg.format(generated_addr))
        else:
            ips.add(generated_addr)

    return ips
