import socket
import logging
import subprocess


LXCBASEDIR = "/var/lib/lxc/"

log = logging.getLogger(__name__.split(".")[-1])
log.addHandler(logging.NullHandler())


def run():
    ips = set()

    try:
        containers = subprocess.check_output(["sudo", "/bin/ls", LXCBASEDIR], universal_newlines=True).split("\n")
    except subprocess.CalledProcessError:
        log.exception("Unable to get list of LXC containers")
        return ips

    for host in containers:
        if host == "":
            continue
        try:
            ipv6addr = socket.getaddrinfo(host, None, socket.AF_INET6)[0][4][0]
            ips.add(ipv6addr)
        except (socket.error, socket.gaierror, socket.herror, socket.timeout):
            continue

    return ips
