from __future__ import print_function

import argparse
from config import Config
import os
import sys


def parse_args():
    parser = argparse.ArgumentParser(
        description="Run Yandex HBF agent in Porto"
    )
    parser.add_argument(
        "--config",
        default="/etc/yandex-hbf-agent/porto.conf",
        help="path to config"
    )
    parser.add_argument(
        "--configspec",
        default="/usr/share/yandex-hbf-agent/porto.configspec",
        help="path to configspec"
    )
    parser.add_argument(
        "--current-config", action="store_true",
        help="dump current configuration (considering defaults) and exit"
    )
    parser.add_argument(
        "--default-config", action="store_true",
        help="dump default configuration file and exit"
    )
    parser.add_argument(
        "--print-cmd", action="store_true",
        help="print portoctl command instead of executing it"
    )
    return parser.parse_args()


def main():
    global args
    args = parse_args()

    if args.default_config:
        errors = Config.dump_default(args.configspec)
        if not errors:
            sys.exit(0)
        else:
            sys.exit(1)

    global config
    config = Config(args.config, args.configspec, check_extra=False)

    if args.current_config:
        print(config)
        sys.exit(0)

    porto_args = [k + "=" + str(v) for k, v in config["properties"].items()]
    cmd = "portoctl"
    porto_args.insert(0, cmd)
    porto_args.insert(1, "exec")
    porto_args.insert(2, "yandex-hbf-agent")
    if args.print_cmd:
        print(cmd, " ".join(porto_args[1:]))
    else:
        os.execvp(cmd, porto_args)
