package main

import "os"

// Keep in sync with default hbf config
const disabledFile = "/var/run/yandex-hbf-agent/disabled"

const disabledMessage = "\x1b[41m=== HBF is DISABLED ===\x1b[49m " +
	"Use 'ya-hbf-enable' to enable)\n"

func main() {
	_, err := os.Stat(disabledFile)
	if !os.IsNotExist(err) {
		_, err = os.Stdout.Write([]byte(disabledMessage))
		if err != nil {
			panic(err.Error())
		}
	}
}
